    <?php
    defined('BASEPATH') OR exit('No direct script access allowed');

    class Comment_model extends CI_Model {
        
        public function __construct() {
            parent::__construct();
            $this->load->database();
        }

        public function get_all_comments($limit = null, $offset = 0) {
            $this->db->where('status', 'approved');
            $this->db->order_by('created_at', 'DESC');
            
            if ($limit !== null) {
                $this->db->limit($limit, $offset);
            }
            
            $comments = $this->db->get('comments')->result();
            
            // Process images field for frontend
            foreach ($comments as $comment) {
                if (!empty($comment->images)) {
                    $comment->images = json_decode($comment->images, true);
                } else {
                    $comment->images = [];
                }
            }
            
            return $comments;
        }

        public function count_all_comments() {
            $this->db->where('status', 'approved');
            return $this->db->count_all_results('comments');
        }

        public function get_comments($type, $item_id) {
            // For products, show all approved product comments on every product page
            if ($type === 'product') {
                $this->db->where('type', 'product');
                $this->db->where('status', 'approved');
                $this->db->order_by('created_at', 'DESC');
            } else {
                // For articles, keep the original behavior (filter by item_id)
                $this->db->where('type', $type);
                $this->db->where('item_id', $item_id);
                $this->db->where('status', 'approved');
                $this->db->order_by('created_at', 'DESC');
            }
            
            $comments = $this->db->get('comments')->result();
            
            // Process images field for frontend
            foreach ($comments as $comment) {
                if (!empty($comment->images)) {
                    $comment->images = json_decode($comment->images, true);
                } else {
                    $comment->images = [];
                }
            }
            
            return $comments;
        }

        public function add_comment($data) {
            $comment_data = array(
                'name' => $data['name'],
                'email' => $data['email'],
                'message' => $data['message'],
                'type' => $data['type'], // 'product' or 'article'
                'item_id' => $data['item_id'],
                'status' => 'pending', // Default status is pending
                'created_at' => date('Y-m-d H:i:s'),
                'image' => isset($data['image']) ? $data['image'] : null, // Save the filename or null (backward compatibility)
                'images' => isset($data['images']) ? $data['images'] : null, // JSON array of image filenames
                'attachment' => isset($data['attachment']) ? $data['attachment'] : null, // Save the attachment filename or null
                'rating' => (isset($data['rating']) && $data['rating'] !== null && $data['rating'] !== '') ? $data['rating'] : null // Star rating for products
            );
        
            return $this->db->insert('comments', $comment_data);
        }

        public function get_pending_comments() {
            $this->db->where('status', 'pending');
            $this->db->order_by('created_at', 'DESC');
            return $this->db->get('comments')->result();
        }

        public function approve_comment($comment_id) {
            $this->db->where('id', $comment_id);
            return $this->db->update('comments', ['status' => 'approved']);
        }

        public function reject_comment($comment_id) {
            $this->db->where('id', $comment_id);
            return $this->db->delete('comments');
        }
    } 