<?php
defined('BASEPATH') or exit('No direct script access allowed');

 

if (!function_exists('get_store_logo')) {
    function get_store_logo()
    {
        $file = get_settings('store_logo');
        return base_url('assets/uploads/sites/' . $file);
    }
}
if (!function_exists('get_sites_assets')) {
    function get_sites_assets($image_name)
    {
        return base_url('assets/uploads/sites/' . $image_name);
    }
}
if (!function_exists('get_product_image')) {
    function get_product_image($image_name)
    {
        return base_url('assets/uploads/products/new/' . $image_name);
    }
}
if (!function_exists('get_image')) {
    function get_image($image_name)
    {
        return base_url('assets/uploads/images/' . $image_name);
    }
}
if (!function_exists('get_partner_image')) {
    function get_partner_image($image_name)
    {
        return base_url('assets/uploads/partner/' . $image_name);
    }
}
if (!function_exists('get_svg')) {
    function get_svg($image_name)
    {
        return base_url('assets/uploads/svg/' . $image_name);
    }
}
if (!function_exists('get_about_image')) {
    function get_about_image($image_name)
    {
        return base_url('assets/uploads/about/' . $image_name);
    }
}
if (!function_exists('get_icon_image')) {
    function get_icon_image($image_name)
    {
        return base_url('assets/uploads/icons/' . $image_name);
    }
}
if (!function_exists('get_senam_image')) {
    function get_senam_image($image_name)
    {
        return base_url('assets/uploads/senam/' . $image_name);
    }
}
if (!function_exists('get_usg_image')) {
    function get_usg_image($image_name)
    {
        return base_url('assets/uploads/usg/' . $image_name);
    }
}
if (!function_exists('get_seminar_image')) {
    function get_seminar_image($image_name)
    {
        return base_url('assets/uploads/seminar/' . $image_name);
    }
}
if (!function_exists('get_testimoni_image')) {
    function get_testimoni_image($image_name)
    {
        return base_url('assets/uploads/testimoni/' . $image_name);
    }
}
if (!function_exists('get_placeholder_image')) {
    function get_placeholder_image()
    {
        return base_url('assets/placeholder.png');
    }
}

if (!function_exists('get_formatted_date')) {
    function get_formatted_date($source_date)
    {
        $d = strtotime($source_date);

        $year = date('Y', $d);
        $month = date('n', $d);
        $day = date('d', $d);
        $day_name = date('D', $d);

        $day_names = array(
            'Sun' => 'Minggu',
            'Mon' => 'Senin',
            'Tue' => 'Selasa',
            'Wed' => 'Rabu',
            'Thu' => 'Kamis',
            'Fri' => 'Jum\'at',
            'Sat' => 'Sabtu'
        );
        $month_names = array(
            '1' => 'Januari',
            '2' => 'Februari',
            '3' => 'Maret',
            '4' => 'April',
            '5' => 'Mei',
            '6' => 'Juni',
            '7' => 'Juli',
            '8' => 'Agustus',
            '9' => 'September',
            '10' => 'November',
            '11' => 'Oktober',
            '12' => 'Desember'
        );
        $day_name = $day_names[$day_name];
        $month_name = $month_names[$month];

        $date = "$day_name, $day $month_name $year";

        return $date;
    }
}

if (!function_exists('format_rupiah')) {
    function format_rupiah($rp)
    {
        return number_format($rp, 2, ',', '.');
    }
}

if (!function_exists('create_product_sku')) {
    function create_product_sku($name, $category, $price, $stock)
    {
        $name = create_acronym($name);
        $category = create_acronym($category);
        $price = create_acronym($price);
        $stock = $stock;
        $key = substr(time(), -3);

        $sku =  $name . $category . $price . $stock . $key;
        return $sku;
    }
}

if (!function_exists('create_acronym')) {
    function create_acronym($words)
    {
        $words = explode(' ', $words);
        $acronym = '';

        foreach ($words as $word) {
            $acronym .= $word[0];
        }

        $acronym = strtoupper($acronym);

        return $acronym;
    }
}

if (!function_exists('count_percent_discount')) {
    function count_percent_discount($discount, $from, $num = 1)
    {
        $count = ($discount / $from) * 100;
        $count = number_format($count, $num);

        return $count;
    }
}

if (!function_exists('get_product_image')) {
    function get_product_image($id)
    {
        $CI = init();
        $CI->load->model('product_model');

        $data = $CI->product_model->product_data($id);
        $picture_name = $data->picture_name;

        if (!$picture_name)
            $picture_name = 'default.jpg';

        $file = './assets/uploads/products/' . $picture_name;

        return base_url('assets/uploads/products/' . $picture_name);
    }
}

if (!function_exists('get_order_status')) {
    function get_order_status($status, $payment)
    {
        if ($payment == 1) {
            // Bank
            if ($status == 1)
                return 'Menunggu pembayaran';
            else if ($status == 2)
                return 'Dalam proses';
            else if ($status == 3)
                return 'Dalam pengiriman';
            else if ($status == 4)
                return 'Selesai';
            else if ($status == 5)
                return 'Dibatalkan';
        } else if ($payment == 2) {
            //COD
            if ($status == 1)
                return 'Dalam proses';
            else if ($status == 2)
                return 'Dalam pengiriman';
            else if ($status == 3)
                return 'Selesai';
            else if ($status == 4)
                return 'Dibatalkan';
        }
    }
}

if (!function_exists('get_payment_status')) {
    function get_payment_status($status)
    {
        if ($status == 1)
            return 'Menunggu konfirmasi';
        else if ($status == 2)
            return 'Berhasil dikonfirmasi';
        else if ($status == 3)
            return 'Pembayaran tidak ditemukan';
    }
}

if (!function_exists('get_contact_status')) {
    function get_contact_status($status)
    {
        if ($status == 1)
            return 'Belum dibaca';
        else if ($status == 2)
            return 'Sudah dibaca';
        else if ($status == 3)
            return 'Sudah dibalas';
    }
}

if (!function_exists('get_month')) {
    function get_month($mo)
    {
        $months = array(
            '1' => 'Januari',
            '2' => 'Februari',
            '3' => 'Maret',
            '4' => 'April',
            '5' => 'Mei',
            '6' => 'Juni',
            '7' => 'Juli',
            '8' => 'Agustus',
            '9' => 'September',
            '10' => 'Oktober',
            '11' => 'November',
            '12' => 'Desember'
        );

        return $months[$mo];
    }
}

if (!function_exists('get_controller')) {
    function get_controller()
    {
        $CI = init();
        $controller = $CI->router->fetch_class();

        return $controller;
    }
}
