<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cors_test extends MY_Controller {
    
    public function __construct() {
        parent::__construct();
    }

    /**
     * Test CORS configuration
     * GET /api/cors_test/test
     */
    public function test() {
        $this->response['status'] = true;
        $this->response['message'] = 'CORS test successful';
        $this->response['data'] = [
            'timestamp' => date('Y-m-d H:i:s'),
            'origin' => isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : 'No origin',
            'method' => $_SERVER['REQUEST_METHOD'],
            'headers' => [
                'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
                'referer' => $_SERVER['HTTP_REFERER'] ?? 'No referer'
            ]
        ];

        $this->output->set_output(json_encode($this->response));
    }

    /**
     * Test POST request for CORS
     * POST /api/cors_test/post_test
     */
    public function post_test() {
        if ($this->input->method() !== 'post') {
            $this->response['message'] = 'Method not allowed';
            $this->output->set_status_header(405)->set_output(json_encode($this->response));
            return;
        }

        $json_input = json_decode($this->input->raw_input_stream, true);

        $this->response['status'] = true;
        $this->response['message'] = 'POST CORS test successful';
        $this->response['data'] = [
            'timestamp' => date('Y-m-d H:i:s'),
            'received_data' => $json_input,
            'origin' => isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : 'No origin',
            'method' => $_SERVER['REQUEST_METHOD']
        ];

        $this->output->set_output(json_encode($this->response));
    }
}