<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['robots.txt'] = 'robots';

// API Routes
$route['api/articles'] = 'api/articles/index';
$route['api/articles/create'] = 'api/articles/create';
$route['api/articles/update/(:num)'] = 'api/articles/update/$1';
$route['api/articles/delete/(:num)'] = 'api/articles/delete/$1';
$route['api/articles/get/(:num)'] = 'api/articles/get/$1';
$route['api/articles/categories'] = 'api/articles/categories';
$route['api/articles/by_category/(:num)'] = 'api/articles/by_category/$1';
$route['api/articles/increment_views/(:num)'] = 'api/articles/increment_views/$1';
$route['api/articles/most_viewed'] = 'api/articles/most_viewed';

$route['api/products'] = 'api/products/index';
$route['api/products/get/(:num)'] = 'api/products/get/$1';

$route['api/comments/get_comments'] = 'api/comments/get_comments';
$route['api/comments/add_comment'] = 'api/comments/add_comment';
$route['api/comments/get_pending_comments'] = 'api/comments/get_pending_comments';
$route['api/comments/approve_comment/(:num)'] = 'api/comments/approve_comment/$1';
$route['api/comments/reject_comment/(:num)'] = 'api/comments/reject_comment/$1';

$route['api/search'] = 'api/search/index';
$route['api/search/suggestions'] = 'api/search/suggestions';

$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
