<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Production Configuration Template
|--------------------------------------------------------------------------
| Copy this file to config.php and update with your production values
*/

// Base URL - Update with your actual domain
$config['base_url'] = 'https://yourdomain.com/';

// Remove index.php from URLs (ensure .htaccess is properly configured)
$config['index_page'] = '';

// Encryption key - Generate a new one for production
$config['encryption_key'] = 'GENERATE_A_32_CHARACTER_RANDOM_STRING_HERE';

// Session configuration
$config['sess_driver'] = 'files';
$config['sess_cookie_name'] = 'ci_session';
$config['sess_expiration'] = 7200;
$config['sess_save_path'] = sys_get_temp_dir();
$config['sess_match_ip'] = FALSE;
$config['sess_time_to_update'] = 300;
$config['sess_regenerate_destroy'] = FALSE;

// Cookie configuration
$config['cookie_prefix']	= '';
$config['cookie_domain']	= '.yourdomain.com'; // Update with your domain
$config['cookie_path']		= '/';
$config['cookie_secure']	= TRUE; // Set to TRUE when using HTTPS
$config['cookie_httponly'] 	= TRUE;

// Security settings
$config['csrf_protection'] = FALSE; // Enable if needed for forms
$config['csrf_token_name'] = 'csrf_token';
$config['csrf_cookie_name'] = 'csrf_cookie';
$config['csrf_expire'] = 7200;

// Compress output
$config['compress_output'] = TRUE;

// Disable profiler in production
$config['enable_profiler'] = FALSE;

// Error logging
$config['log_threshold'] = 1; // Only log errors
$config['log_path'] = '';
$config['log_file_extension'] = '';
$config['log_file_permissions'] = 0644;
$config['log_date_format'] = 'Y-m-d H:i:s';

// Cache configuration
$config['cache_path'] = '';
$config['cache_query_string'] = FALSE;

// Other important settings
$config['uri_protocol']	= 'REQUEST_URI';
$config['url_suffix'] = '';
$config['language']	= 'english';
$config['charset'] = 'UTF-8';
$config['enable_hooks'] = FALSE;
$config['subclass_prefix'] = 'MY_';
$config['composer_autoload'] = FALSE;
$config['permitted_uri_chars'] = 'a-z 0-9~%.:_\-';
$config['allow_get_array'] = TRUE;
$config['controller_trigger'] = 'c';
$config['function_trigger'] = 'm';
$config['directory_trigger'] = 'd';
$config['enable_query_strings'] = FALSE;
$config['standardize_newlines'] = FALSE;
$config['global_xss_filtering'] = FALSE;
$config['csrf_regenerate'] = TRUE;
$config['csrf_exclude_uris'] = array('api/.*');
$config['rewrite_short_tags'] = FALSE;
$config['proxy_ips'] = '';